def solve_types(ir)
  queue = ir.size.times.to_a

  deps = ir.map{[]}
  queue.each{|i|ir[i].args.each{|a|deps[a]<<i}}
  deps.map!(&:uniq)

  types = ir.map{EmptyType}

  queue.each{|i|
    op = ir[i].op
    arg_types = ir[i].args.map{|a|types[a]}
    begin
      way = find_way(ir[i], op, arg_types)
    rescue IogiiError # no match yet
      next
    end
    result_type = spec_to_ret(way, ir[i].args.map{|a|types[a]})
    # todo handle case where it is < (char char -)
    if result_type > types[i]
      types[i] = result_type
      queue.concat(deps[i])
    elsif result_type < types[i]
      raise IogiiError.new "type invariant has been violated", ir[i] #todo see nitty gritty, test it
    end
  }
  types
end

def find_way(node, op, arg_types, arg_ranks = [0]*arg_types.size)
  x = op.ways.map{|way|
    excess = excess_ranks(way, arg_ranks, arg_types)

    # Prefer to promote 1 arg rather than use vectorized low rank overload
    # todo: don't do this here if there become more specific cases
    excess = [0,0] if ["Append","SetDiff"].any?{|n|Ops[n].ways[0] == way} && excess.sort == [-1,0]

    [ spec_matches(way.arg_types, arg_types).sort.reverse, # most weight on no_matches
      excess.map{|e| [-e, 0].max }.sort.reverse, # only care about when rank too low
      excess.map{|e| [e, 0].max }.sort.reverse, # but still prefer no excessive rank (for special promotes)
      way.arg_types.sort, # for ops that have special case for empty (zero)
      way.mod_arg_ranks.sort # finally look at spec ranks since empty type never has excess
    ]
  }
#   p x if op.name == "zero"
  xmin_at = (0...x.size).min_by{|i| x[i] }
  xmin = x[xmin_at]
  raise(IogiiError.new "op is not defined for base types: " + arg_types.map{|t|type_to_str(t)}*" ", node) if xmin[0][0] == :m2_no_match
  effects = (0...x.size).filter{|i| x[i] == xmin }.map{|i|
    way = op.ways[i]
    [way.impl, way.ret_type, way.ret_rank] }
  raise "internal error, ambiguous op %p: %p" % [node.token.str, op.name] if effects.uniq.size > 1
  op.ways[xmin_at]
end

def find_valid_way(node, arg_types, arg_ranks)
  way = find_way(node, node.op, arg_types, arg_ranks)

  excess = excess_ranks(way, arg_ranks, arg_types)
  excess.each.with_index{|e,i|
    raise IogiiError.new "arg #{i+1} rank too low and op does not promote (see #{NittyGritty}#promotion )", node if e < 0 && (way.promote.include?(false) || way.promote.include?(NotFirst) && i==0) }

  if !way.can_mod? && node.token && node.token.str[-1] == ","
    begin
      simpler_op = lookup_op(node.token.str[0...-1])
      simpler_way = find_way(node, simpler_op, arg_types, arg_ranks) if simpler_op
    rescue IogiiError
    end
    raise IogiiError.new "extra , used", node if simpler_way == way
  end

  way
end

def solve_ranks(ir,types)
  queue = ir.size.times.to_a

  deps = ir.map{[]}
  queue.each{|i|ir[i].args.each{|a|deps[a]<<i}}
  deps.map!(&:uniq)

  ranks = ir.map{0}

  queue.each{|i|
    op = ir[i].op
    arg_types = ir[i].args.map{|a|types[a]}
    arg_ranks = ir[i].args.map{|a|ranks[a]}
    way = find_way(ir[i], op, arg_types, arg_ranks)
    #technically result rank is wrong if !.vectorize, and generic type but none of those return a generic type
    result_rank = zip_level(way, arg_ranks, arg_types) + way.mod_ret_rank
    if result_rank > 100 # todo distinguish between this and legitimate cases (which for all practical purposes will never exist)
      raise IogiiError.new "cannot construct the infinite type", ir[i]
    elsif result_rank > ranks[i]
      ranks[i] = result_rank
      queue.concat(deps[i])
    elsif result_rank < ranks[i]
      raise IogiiError.new "rank invariant has been violated", ir[i] #todo see nitty gritty, test it
    end
  }
  ranks
end

def excess_ranks(way, ranks, types)
  ranks.zip(types, way.mod_arg_ranks, coerce?(way.arg_types,types)).map{|r, t, o, c|
    e = r-o+(c ? 1 : 0)
    e = [0, e].min if !way.vectorize
    e = [0, e].max if t == EmptyType
    e
  }
end

def zip_level(way, ranks, types)
  (excess_ranks(way, ranks, types)<<0).max
end
