require_relative "./lex.rb"
require_relative "./error.rb"
require_relative "./parse.rb"
require_relative "./ir.rb"
require_relative "./infer.rb"
require_relative "./promise.rb"
require_relative "./version.rb"
require_relative "./auto_parse.rb"

NittyGritty = "https://golfscript.com/iogii/nittygritty.html"

def run(source, arg=nil)
  tokens = lex(source)

  raw_mode = if !tokens.empty? && tokens[0].str == ">"
    tokens.shift
    true
  end

  ast, ast_inds, registers, preprints=*parse_main(tokens)

  override_input = false
  arg_used = ast.any?{|a| (AST === a || BlockAST === a) && a.args.any?{|a2|a2 == 0}}
  arg ||= if arg_used && !raw_mode
    value, type, rank, empty_input = parse_input
    if empty_input && registers[RegisterName]
      override_input = true
      new_op("inputFromProgram", "a -> a"){|a| a.value } # todo inefficient way to do this
    else
      new_op("autoInput", type_and_rank_to_str(type, rank)){ value }
    end
  else
    new_op("stdinLines", "[[char]]"){ lines($ReadStdin) }
  end

  ir, ast2ir = *to_ir(ast, arg, registers, override_input)
  types=solve_types(ir)
  ranks=solve_ranks(ir, types)
  promises=make_promises(ir, ranks, types)
  stack_inds = ast_inds.map{|i| ast2ir[i] }
  preprint_inds = preprints.map{|i| ast2ir[i] }
  return [ir, stack_inds, types, ranks, promises, preprint_inds]
end

def run_and_do_io(source)
  ir, ir_inds, types, ranks, promises, preprint_inds = run(source)
  begin
    preprint_inds.each{|ir_ind|
      printv(promises[ir_ind].value, types[ir_ind], ranks[ir_ind])
      output "\n"
    }

    ir_inds.each{|ir_ind|
      if $pretty_print
        printv(inspectv(types[ir_ind], ranks[ir_ind], promises[ir_ind]), CharType, 1)
        output "\n"
      else
        printv(promises[ir_ind].value, types[ir_ind], ranks[ir_ind])
      end
    }
  rescue SystemStackError => e
    raise IogiiError.new "Stack Overflow"
  end
end
