# todo add subgraphs around functions
# todo layout horizontally better
# todo allow export or link to online graphviz editor
def ast2viz(ast, output_inds, vars)
  output = ""
  skips = {}
  dup_names = "dup mdup : ;".split
  ast.each.with_index{|a,i|
    if AST === a && dup_names.include?(a.token.str)
      skips[i] = a.args[0]
    end
  }

  draw_node = -> i,label {
    sets = vars.filter{|k,v|v == i}.keys
    label += " set:" + sets*',' if !sets.empty?
    style = "[shape=Msquare]" if output_inds.include? i
    output<< "a#{i} #{style} [label=#{label.inspect}];\n"
  }

  draw_arg_arrows = -> a,i {
    return if skips[i]
    a.args.each.with_index{|arg,arg_ind|
      arg = skips[arg] if skips[arg]
      arrowhead = "[arrowhead=empty]" if arg_ind > 0
      output<< "a#{arg} -> a#{i} #{arrowhead};\n"
    }
    draw_node[i,a.token.str]
  }

  output<< "digraph {\n"
  arg_used =  ast.any?{|node|
    ((AST === node || BlockAST === node) && node.args.include?(0)) ||
    (BlockAST === node && node.block == 0) ||
    output_inds.include?(0)
  }
  ast.each.with_index{|a,i|
    next if i == 0 && !arg_used
    case a
    when ArgNode
      draw_node[i, i==0 ? "main arg" : "arg"]
    when DataNode
      draw_node[i, a.str]
    when VarNode
      draw_node[i, "var:#{a.name}"]
    when BlockAST
      draw_arg_arrows[a,i]
      output<< "a#{a.block} -> a#{i} [style=dashed];\n"
      output<< "a#{i} -> a#{a.block_arg} [style=dashed];\n"
    when AST
      draw_arg_arrows[a,i]
    else raise
    end
  }
  output<< "}\n"
  output
end

# todo show if implicit (maybe could use arrow type for implicit ops?)
# todo show range of zip levels
def ir2viz(ir2,out_inds)
  output = ""
  output<< "digraph {\n"
  output<< "node [fontname = \"courier\", ];\n"
  arg_used = ir2.any?{|node|node.args.include?(0) || out_inds.include?(0)
}
  ir2.each.with_index{|node,i|
    next if i == 0 && !arg_used
    node.args.each.with_index{|arg,arg_ind|
      arrowhead = "[arrowhead=empty]" if arg_ind > 0
      output<< "a#{arg} -> a#{i} #{arrowhead};\n"
    }

    label = node.way.name == "data" ?
      to_eager_str(inspectv(node.type,node.rank,node.way.impl.call.const)).inspect :
      ("."*node.zip_level + node.way.name).inspect
    color = case node.type
      when IntType
        '[fontcolor="#ff6600"]'
      when CharType
        '[fontcolor="#005c99"]'
      else
        ""
      end
    style = "[shape=Msquare]" if out_inds.include? i
    style2 = "[style=dashed]" if node.rank == 0
    output<< "a#{i} #{color} #{style} #{style2} [peripheries=#{[node.rank,1].max}] [label=#{label}];\n"
  }
  output<< "}\n"
  output
end
