require_relative "./lex.rb"
require_relative "./error.rb"
require_relative "./parse.rb"
require_relative "./ir.rb"
require_relative "./ir2.rb"
require_relative "./infer.rb"
require_relative "./version.rb"
require_relative "./auto_parse.rb"
require_relative "./hs.rb"

NittyGritty = "https://golfscript.com/iogii/nittygritty.html"

def lex_parse(source)
  tokens = lex(source)
  raw_mode = if !tokens.empty? && tokens[0].str == ">"
    tokens.shift
    true else false end
  ast, ast_inds, registers = *parse_main(tokens)
  arg_used = ast.any?{|a| (AST === a || BlockAST === a) && a.args.any?{|a2|a2 == 0}} || ast_inds.any?{|a| a == 0 }
  raw_mode |= !arg_used
  [ast, ast_inds, registers, raw_mode]
end

def run(source, arg=nil, pp_sep=nil)
  ast, ast_inds, registers, raw_mode = *lex_parse(source)
  override_input = false
  arg ||= if !raw_mode
    value, type, rank, empty_input = parse_input
    override_input = empty_input && registers[RegisterName]
    new_op("autoInput#{"List"*rank}#{type_to_str(type).capitalize}", type_and_rank_to_str(type, rank)){ value }
  else
    new_op("stdinLines", "[[char]]"){ $ReadStdinLines.value }
  end

  ir, ir_inds = *to_ir(ast, arg, registers, override_input, ast_inds)
  types=solve_types(ir)
  ranks=solve_ranks(ir, types)
  ir2,ir2_inds = to_ir2(ir, ranks, types, ir_inds)
  ir3,ir3_ind = to_ir3(ir2, ir2_inds, pp_sep)
  return [ast, ast_inds, registers, ir2, ir2_inds, ir3, ir3_ind]
end

def run_and_do_io(source,pp,hs)
  pp_sep = pp ? "\n" : nil
  if hs
    generate_hs(source, pp_sep)
  else
    ast, ast_out_inds, registers, ir2, ir2_inds, ir3, ir3_ind = run(source, nil, pp_sep)
    promises = make_promises(ir3)
    begin
      prints(promises[ir3_ind].value)
    rescue SystemStackError => e
      raise IogiiError.new "Stack Overflow"
    end
    [ast, ast_out_inds, registers, ir2, ir2_inds]
  end
end
