# Prefixed so that they can be compared
EmptyType = :t0_empty # the type of an empty list, it can be anything
IntType = :t1_int
CharType = :t2_char
XSpec = :t3_s_x
ASpec = :t4_s_a
BSpec = :t5_s_b

def type_spec_parts(spec)
  spec.gsub("->"," ").split
end

def concrete_rank(spec)
  !(spec == ASpec || spec == BSpec) # todo what about empty?
end

def concrete_type(spec)
  !(spec == ASpec || spec == BSpec || spec == XSpec)
end

def spec_rank(part)
  t = spec_type(part)
  r = part.scan('[').size
  concrete_rank(t) ? r : ~r
end

def spec_type(part)
  case part.tr('[]','')
  when "x"
    XSpec
  when "a"
    ASpec
  when "b"
    BSpec
  when "int"
    IntType
  when "char"
    CharType
  when ""
    EmptyType
  else raise "unknown arg type" % part
  end
end

def type_to_str(sym)
  sym.to_s.sub(/^.*_/,'')
end
def type_and_rank_to_str(type,rank)
  r = "["*rank + type_to_str(type) + "]"*rank
  r == "[empty]" ? "[]" : r
end

def spec_matches(specs, args)
  specs.zip(args, coerce?(specs, args)).map{|s, a, c|
    spec_match(s, a) ? (c ? :m1_coerces : :m0_matches) : :m2_no_match
  }
end

def spec_match(spec, arg)
  return false if arg == EmptyType && (spec == IntType || spec == CharType)
  return false if spec == EmptyType && arg != EmptyType
  !(spec == IntType && arg == CharType)
end

def same_spec(specs, args, target)
  args.filter.with_index{|a,i| specs[i] == target }
end

def spec_to_ret(way, args)
  if concrete_type(way.ret_type)
    way.ret_type
  else
    same_spec(way.arg_types, args,  way.ret_type).max || EmptyType
  end
end

def coerce?(specs,args)
  specs.zip(args).map{|s,a|
    if s == CharType && a == IntType
      true
    else
      !concrete_type(s) && a == IntType && same_spec(specs, args, s).any?{|o| o == CharType }
    end
  }
end

