require_relative "./lex.rb"
require_relative "./lazylib.rb"

SepRx = /, | |,/
NumRx = /-*\d+/

def parse_input
  lazy_input = $ReadStdinLines
  eager_input = to_eager_list(lazy_input)
  # is it just numbers?
  if lazy_input.empty
    [[], EmptyType, 1]
  elsif eager_input.all?{|line| to_eager_str(line) =~ /^(#{NumRx}#{SepRx})*#{NumRx}?$/ } &&
      eager_input.any?{|line| to_eager_str(line) =~ NumRx } &&
      eager_input.all?{|line| to_eager_str(line).scan(NumRx).all?{|num| num == num.to_i.to_s } }
    read = map(lazy_input){|v|split_non_digits(v)}
    eager = to_eager_list(read.const).map{|a| to_eager_list(a.const) }


    if eager.size == 1 && eager[0].size == 1 # is it 1 number
      [eager[0][0], IntType, 0]
    elsif eager.size == 1 # is it a row
      [read[0].value, IntType, 1]
    elsif eager.all?{|a|a.size == 1} # is it a col
      [map(read.const){|v|v.value[0].value}, IntType, 1]
    else # its a matrix
      [read, IntType, 2]
    end
  else # not numbers
    if eager_input.size > 1 # multi line
      [lazy_input.value, CharType, 2]
    else
      [lazy_input.empty ? [] : lazy_input.value[0].value, CharType, 1]
    end
  end
end