require_relative "./lex.rb"
require_relative "./error.rb"
require_relative "./parse.rb"
require_relative "./ir.rb"
require_relative "./ir2.rb"
require_relative "./infer.rb"
require_relative "./version.rb"
require_relative "./auto_parse.rb"
require_relative "./hs.rb"

Site = "https://golfscript.com/iogii/"

def is_raw_mode(tokens)
  !tokens.empty? && tokens[0].str == ","
end

def gen_graph(source, pp_sep: nil, ast_cb: nil, ir_cb: nil)
  tokens = lex(source)

  raw_mode = is_raw_mode(tokens)
  tokens.shift if raw_mode
  ast, ast_inds, registers = *parse_main(tokens, raw_mode)

  ast_cb[ast, ast_inds] if ast_cb

  input_op = promise { # don't eval this unless needed since awaits input
    if raw_mode
      if $raw_args
        new_op("rawArgs", "[[char]]"){ $ReadStdinLines.value }
      else
        new_op("rawStdin", "[char]"){ $ReadStdin.value }
      end
    else
      value, type, rank = parse_input
      new_op("autoInput#{"List"*rank}#{type_to_str(type).capitalize}", type_and_rank_to_str(type, rank)){ value }
    end
  }

  ir, ir_inds = *to_ir(ast, registers, ast_inds, input_op)
  types=solve_types(ir)
  ranks=solve_ranks(ir, types)

  ir2,ir2_inds = to_ir2(ir, ranks, types, ir_inds)
  ir_cb[ir2, ir2_inds] if ir_cb
  ir3,ir3_ind = to_ir3(ir2, ir2_inds, pp_sep)
  return [ir3, ir3_ind]
end

def run_and_do_io(source,pp,hs,ast_cb: nil,ir_cb: nil)
  pp_sep = pp ? "\n" : nil
  if hs
    generate_hs(source, pp_sep)
  else
    ir3, ir3_ind = gen_graph(source, pp_sep: pp_sep, ast_cb: ast_cb, ir_cb: ir_cb)
    promises = make_promises(ir3)
    begin
      prints(promises[ir3_ind].value)
    rescue SystemStackError => e
      raise IogiiError.new "Stack Overflow\n(You can increase the limit with the shell command: export RUBY_THREAD_VM_STACK_SIZE=<size in bytes>\nor compile to haskell with -hs to remove the limit)."
    end
  end
end
