require 'stringio'
require 'timeout'
require "./run.rb"

special_things = %w'$ ! > , : ; [ { f F m M i I e E nil del superpad implicit input type show set let del  1,2,3 0,0 1,2,,3,4 "asdf" "" 1000'


all = ["\n",*' '..'~'] + special_things*3 + [" "]*2

n = 3000

def run_hs(prog, input)
  File.open("prog.iog", "w"){|f| f << prog }
  File.open("input.txt", "w"){|f| f << input }
  begin
    Timeout::timeout(4.01) {
    `(ruby main.rb prog.iog -hs > test.hs && runhaskell test.hs < input.txt) 2>&1`
    }
  rescue Timeout::Error
    "timeout"
  end
end

3.upto(8){|program_size|
  ([all.size**program_size,n].min).times{|i|
    input = ["","\n","ab12","12","1 2","1 2\n3","c","ab\n\n2"].sample
  $ReadStdinLines = lines(Promise.new{ str_to_lazy_list(input) }).const
    STDERR.puts

    program = program_size.times.map{ all.sample }*" "
    STDERR.puts "input: %p" % input
    program.gsub!(' ,',',')
    $stdout = StringIO.new("")
    begin
      STDERR.puts "program: " + program
      Timeout::timeout(0.01) {
        run_and_do_io(program, false, false)
      }
    rescue IogiiError => e
      $stdout << e.message
    rescue Timeout::Error
      next
    rescue => e
      STDERR.puts "failed, program was:"
      STDERR.puts program
      raise e
    end

    out = $stdout.string
    $stdout = STDOUT
    next if out["Stack Overflow"]

    puts "ruby output: %p" % [out]
    out_hs = run_hs(program, input)
    if out_hs =~ /^test.hs: (.*?)\nCallStack.*/m
      out_hs = $1
    end
    next if out_hs["infinite type"] #############################
    next if out_hs["Prelude.chr: bad argument"] && out["char out of range"]
    out_hs.gsub!(/^.*WARNING.*splitting.*\n/,'')
    puts "haskell output: %p" % [out_hs]


    exit if out != out_hs
  }
}
