IR = Struct.new(:op, :args, :token)

def to_ir(ast_nodes, arg, registers)
  nodes = [IR.new(arg, [], nil)]
  ast2ir = { 0 => 0 }
  ast_nodes.size.times{|ast_ind| to_ir_h(ast_nodes, ast_ind, nodes, ast2ir, registers) }
  replace_vars = lambda{|a| a=a[] while Proc === a; a }
  nodes.each{|n|n.args.map! &replace_vars }
  ast2ir.each{|k,v| ast2ir[k] = replace_vars[v] }
  [nodes, ast2ir]
end

def to_ir_h(ast_nodes, ast_ind, nodes, ast2ir, registers)
  return ast2ir[ast_ind] if ast2ir[ast_ind]
  ir_ind = nil
  ast2ir[ast_ind] = ->{ir_ind}
  ast_node = ast_nodes[ast_ind]
  ir_ind = case ast_node
    when ArgNode
      ->{ ast2ir[ast_node.arg_ind] }
    when VarNode
      ->{ ast2ir[registers[ast_node.name]] }
    when DataNode
      nodes << IR.new(ast_node.impl, [], nil)
      nodes.size - 1
    when AST
      args = ast_node.args.map{|a|to_ir_h(ast_nodes, a, nodes, ast2ir, registers)}
      op = lookup_op(ast_node.token.str)

      if op.name == "dup"
        args[0]
      else
        nodes << new_node = IR.new(op, args, ast_node.token)
        nodes.size - 1
      end
    when BlockAST
      args = ast_node.args.map{|a|to_ir_h(ast_nodes, a, nodes, ast2ir, registers)}
      op = lookup_op(ast_node.token.str)
      mod = op.ways[0].mod

      if op.name == "mdup"
        ast2ir[ast_node.block_arg] = args[0]
        to_ir_h(ast_nodes, ast_node.block, nodes, ast2ir, registers)
      elsif op.name == "iterate"
        nodes << IR.new(Ops["cons"].dup_mod(mod), cons_args=[nil, args[0]], ast_node.token)
        consed_ind = nodes.size - 1
        nodes << IR.new(Ops["superpad"].dup_mod(mod), [nodes.size-1], ast_node.token)
        ast2ir[ast_node.block_arg] = nodes.size - 1
        cons_args[0] = to_ir_h(ast_nodes, ast_node.block, nodes, ast2ir, registers)
        consed_ind
      elsif op.name == "iterate0"
        nodes << IR.new(mod > 0 ? Ops["zerom"].dup_mod(mod) : Ops["zero"], zero_args=[nil], ast_node.token)
        nodes << IR.new(Ops["cons"].dup_mod(mod), cons_args=[nil, nodes.size-1], ast_node.token)
        consed_ind = nodes.size - 1
        nodes << IR.new(Ops["superpad"].dup_mod(mod), [nodes.size-1], ast_node.token)
        ast2ir[ast_node.block_arg] = nodes.size - 1
        cons_args[0] = zero_args[0] = to_ir_h(ast_nodes, ast_node.block, nodes, ast2ir, registers)
        consed_ind
      elsif op.name == "foldr"
        nodes << IR.new(Ops["superpad"].dup_mod(mod), superpad_args=[nil], ast_node.token)
        nodes << IR.new(Ops["pad"].dup_mod(mod), [nodes.size-1, args[0]], ast_node.token)
        nodes << IR.new(Ops["tail"].dup_mod(mod), [nodes.size-1], ast_node.token)
        ast2ir[ast_node.block_arg] = nodes.size - 1
        superpad_args[0] = block_result = to_ir_h(ast_nodes, ast_node.block, nodes, ast2ir, registers)
        nodes << IR.new(Ops["head"].dup_mod(mod), [block_result], ast_node.token)
        nodes.size - 1
      elsif op.name == "foldr0"
        nodes << IR.new(Ops["superpad"].dup_mod(mod), superpad_args=[nil], ast_node.token)
        nodes << IR.new(mod > 0 ? Ops["zerom"].dup_mod(mod) : Ops["zero"], [nodes.size-1], ast_node.token)
        nodes << IR.new(Ops["pad"].dup_mod(mod), [nodes.size-2, nodes.size-1], ast_node.token)
        nodes << IR.new(Ops["tail"].dup_mod(mod), [nodes.size-1], ast_node.token)
        ast2ir[ast_node.block_arg] = nodes.size - 1
        superpad_args[0] = block_result = to_ir_h(ast_nodes, ast_node.block, nodes, ast2ir, registers)
        nodes << IR.new(Ops["head"].dup_mod(mod), [block_result], ast_node.token)
        nodes.size - 1
      else raise
      end
    else raise "unhandled node type %p" % ast_node.class
  end
  ir_ind
end
