require 'cgi'

class String
  def td
    "<td>"+self.escape+"</td>"
  end
  def tdcode(name=false)
    "<td><code>"+self.gsub(/(-|=)>/,"→").escape+"</code></td>"
  end
  def escape
    CGI.escape_html self
  end
end

puts '<table class="quickref">'

def category(name)
  $done = true if name["internal"]
  return if $done
  puts '<tr><td colspan="3" class="center"><b>'+name+'</b></td></tr>'
end

def quickref_op(names, desc, example)
  puts '<tr>'+names.tdcode(true)+desc.td+example.tdcode+"</tr>"
end

def mk_op(names, type_sig, example="", block: false, vectorize: true, promote: true, &impl)
  return if $done
  return if names["or,"] # these are special cases to not coerce condition

  puts "<tr>"
  if names == $last_names
    puts "".td
  else
    puts names.tdcode(true)
    $last_names = names
  end

  type_sig = if names["foldr0"]
    "([a] -> [a]) -> a"
  elsif names["iterate0"]
    "([a] -> [a]) -> [a]"
  elsif names["foldr"]
    "a ([a] -> [a]) -> a"
  elsif names["iterate"]
    "a ([a] -> [a]) -> [a]"
  elsif names["mdup"]
    "a (a -> b) -> b a"
  elsif names["dup"]
    "a -> a a"
  else
    type_sig
  end
  if ["pp","nuke"].include? names
    type_sig = type_sig[/^.*->/]
  end

  puts type_sig.tdcode
  puts example.sub('+ (unstable)','').tdcode
  puts "</tr>"
end

require "./ops.rb"

puts "</table>"
