# Source

To run iogii save the "1 File" from the latest release (below) as `iogii` and `chmod +x` it, then run `iogii <filename.iog>` (it is standalone ruby code with no dependencies).

You can also download "All Source" and run `cd src; ruby main.rb <filename.iog>`. This includes the original source files, all tests, and site generation code.

The current version is compatible with Ruby 2.7.2 - 3.1.2 (and likely beyond in both directions). And if you use Haskell code generation (with the `-hs` flag), it is compatible with GHC 8.10.7.

I am not using github due to them not respecting licenses by training LLMs on code without crediting said code when used in a response.

### 0.3 (Beta) - March 18, 2025

-   [1 File](iogii-0.3-beta)
-   [All Source](iogii-0.3-beta.tgz)
-   [Website Snapshot](0.3/)

Apologies for the large number of major changes. I have no further plans for large changes and should just be making minor changes and fixing bugs/documentation in the future.

Changes:

-   Remove block syntax, now ops that create loops act like regular values syntactically
    -   Removes need for `!` and nested rotation trick, instead just place values that needed to be to the left of the arg to the left of the loop op.
    -   Allow `>,` to match previous loop creation ops skipping initial match
-   `>` in main function [overrides implicit values](syntax.html#unmatchedendbrackets) like how `@` did.
-   Additional implicit values beyond the initial input use the `$` of where they are used (they are also placed at beginning of unrotated program).
-   Auto input is removed from the stack if empty and implicits used instead.
-   Add [set next var](syntax.html#setnextvarcodeclassinlinecode) (`=`).
-   Remove `[`, `]`, and `@` ops, use new `=` instead.
-   `mdup` / `mpeek` cannot match `>` (this allows them to always be skipped when matching `>`, use set next var instead if you needed that).
-   Rename assignment from `~` to `set` and add `let` syntax (alias for `set` ... `del`).
-   Change [broadcasting](vectorization.html#broadcastingwithexcessrank) when there is excess rank.
-   Better handling of [ops with two generic types](types.html#opswithtwogenerictypes), e.g. sortBy.
-   Fix an assortment of bugs (please report any new ones!).
-   Support negation in data format, e.g. `1,2~,3 = [1,-2,3]`
-   Use the system's character encoding rather than bytes. You can force a string literal to still use bytes with `""b`.
-   `-` cannot subtract char from char (use `^` now), this is to uphold an invariant that makes circular type inference sound.
-   Change `charClass` op to be a unary function that returns all chars in given character class.
-   `iterate` takes a list to prepend instead of a single value
-   empty auto input is `nil` instead of empty string
-   Empty type defaults to Int when used as a scalar (before errored).
-   You can do a vectorized op with a list of empty type (nil), this would usually be useless since result will always be an empty list (before errored).
-   `keep` promotes first via repeat (to easily generate a fixed number of scalars for example).
-   `chunkWhen` returns rest of first list when second list runs out
-   Raw mode for stdin does not break input into lines (also created with `,` now).
    -   Add `lines` (`p`) low rank overload to approximate old behavior.
-   Add `peek`, `mpeek`, `consDefault`, `rightJustify`, `dropUntilAfterSubstring`, `keepUntilSubstring`, `getSubstring`, and `init` ops
-   Remove `or` (use `max` or `ifElse` instead)
-   Renaming of several ops, the purpose of which is to provide better mnemonics and make some ops more generic.
    -   `=` → `q` (equal)
    -   `s` → `&` (sortBy)
    -   `q` → `s` (len)
    -   `#` → `_` (sum)
    -   `P` → `.` (prod)
    -   `|` → `L` (abs) (low rank overload)
    -   `_` → `~` (negate / read)
    -   `|` → `.` (ord)
    -   `P` → `_` (words)
    -   `A` → `(,` (min) (now generic and not a low rank overload).
    -   `X` → `x` (max) (now generic and not a low rank overload).
    -   `x` → `\` (setDiff)
    -   `&` → `#` (reshape)
    -   `\` → `|` (chunkWhen)
    -   `W` → `#` (fromBase) (`W` not valid overload with new behavior of `a` `b` types).

### 0.2 (Alpha) - Dec 11, 2024

-   [1 File](iogii-0.2-alpha)
-   [All Source](iogii-0.2-alpha.tgz)
-   [Website Snapshot](0.2/)

Changes:

-   Clarified `reshape` behavior, explained in new [Ops](ops.html) page.
-   Fix bug with `,` following token that was split up, e.g. `nJ,`
-   Add Graphviz visualizations to online interpreter.
-   Support Haskell code generation (~50x speedup + no stack overflow limit)
-   Remove `pp`
-   `show` now prints like Haskell would
-   Rename `nuke` to `del`
-   Remove regex `match`
-   Add `charClass` [op](ops.html#charclass)
-   Output chars mod 256 rather than error if out of range
-   `expand` does not return the initial value now (thanks UnrelatedString for the suggestion).
-   Change `transpose` to insert default values so that truncation is never needed.
-   Support input from command line args after `--`.

### 0.1 (Alpha) - Nov 7, 2024

-   [1 File](iogii-0.1-alpha)
-   [All Source](iogii-0.1-alpha.tgz)
-   [Website Snapshot](0.1/)

Changes:

-   Add more string ops
    -   `charRange ^`
    -   `uppercase U`
    -   `lowercase L`
    -   `parts P` (split on whitespace)
    -   `chr |,` (convert int to char)
    -   `match +` to match regexes.
-   Allow unterminated strings.
-   Allow [implicit args](syntax.html#implicitargs).
-   Add auto parsing of input.
-   `@` also sets input if none present.
-   Make `pow ^` work more consistently for negative numbers and not overflow for large numbers.
-   Remove ops: `nfoldProd p`, `and y`
-   Add ops: `pad p`, `index .`, `get g`
-   Rename ops:
    -   `chunkWhen` `.` → `\`
    -   `transpose` `\` → `p` (pivot). So that it can be unvectorized and also provide nice overload for `prod`.
    -   `digits` `\` → `p` (it's like transposing a string)
    -   `last` `z` → `l`
    -   `len` `l` → `q` (quantity)
    -   `equal` `q` → `=`
    -   `assignment` `=` → `~`
    -   `generate` `g` → `K` (kCopy), no longer generic
    -   `if` → `y` (yes no)
    -   `sum` `_` → `#`
    -   `negate / read` `~` → `_`
    -   `pow10` `Z` → `H` (hyper)
    -   `sqrt` `H` → `u` (unsquare)
    -   `toBase` `#` → `D` (digitize)
    -   `fromBase` `#,` → `W` `baseFrom` (base was). Note that arg order is also swapped - necessary to have vectorized overload.

### 0.0 (Alpha) - Oct 29, 2024

Initial release. Uses Ruby 3.1.2.

-   [1 File](iogii-0.0-alpha)
-   [All Source](iogii-0.0-alpha.tgz)

SHA256 sum of 1 File: d325338fab8c0d44a94a2dd85c9deda61d32fe20521e4c125c99d142e37e5a5c

