raise "generate site using utf-8, not %p" % Encoding.default_external if Encoding.default_external != Encoding::UTF_8

`mkdir ../site` if !Dir["../site"]

Dir['docs/*.md'].each{|filename|
  basefile = filename.sub(/\.md$/,'').sub('docs/','')
  md = File.read(filename)
  md = "[iogii](index.html) ⸱ [Nitty Gritty](nittygritty.html) ⸱ [Quick Ref](quickref.html) ⸱ [Source](source.html)\n\n" + md
   File.open('t.md','w'){|f|f<<md.gsub(/(\[.*\])\((docs\/)*((.+)\.md)\)/,'\1(\4.html)').gsub('->', '→')}
  html = `markdown.pl < t.md`
  `rm t.md`

  if !filename["quickref.md"]
    html.gsub!('<code>','<code class="inline">')
    html.gsub!('<pre><code class="inline">','<pre><code>')
  end

  html.gsub!('<p>$quickref</p>', `ruby web/quickref.rb`)

  html.sub!(/<p>/,'<p class="noprint">') # don't print the heading links

  html.sub!(/<h1>(.*?)<\/h1>/,filename["quickref.md"] ? '<h1 class="noprint">\1</h1>' : '\&')
  title = $1
  title = "iogii" if filename == "index.md"

  def showid(name)
    name = name.downcase.tr'^a-z0-9',''
    name.empty? ? "" : " id=\"#{name}\""
  end

  html.gsub!(/<(h[1-3])>(.*?)<\/\1>/){"<#$1#{showid($2)}>#$2</#$1>"}

  if title.nil?
    puts 'skipping '+filename
    return
  end

  # device width thing is to stop mobile browsers from scaling the page weird, messing up the header links
  File.open('../site/'+basefile+'.html','w'){|f|f<<'<!DOCTYPE html>
<html lang="en"><!-- This file is automatically generated from generate_site.rb by reading '+filename+' --><head><meta name="viewport" content="width=device-width, initial-scale=1"><meta charset="utf-8"><title>'+title+'</title><link rel="stylesheet" href="style.css"><link rel="icon" href="ig.svg" type="image/svg+xml"></head><body>
<div id="content">'+html+'</div>
</body></html>'}
}

`cp web/style.css web/ig.svg ../site/`
