Header = %q(import System.IO
import Data.List
import Data.Char
import Data.String
import Data.Maybe
import System.Info
import qualified Data.Set as Set
import System.Environment

myChr :: Integer -> Char
myChr i = chr $ fromIntegral i `mod` 256
myOrd :: Char -> Integer
myOrd c = fromIntegral $ ord c
bool2i :: Bool -> Integer
bool2i b = if b then 1 else 0
falseChars = Set.fromList [0,9,10,11,12,13,32]
readAll :: String -> [Integer]
readAll xs =
  if num == [] then []
  else sign * (read num :: Integer) : readAll afterNum
  where
    (beforeNum,atNum) = span (not . isDigit) xs
    (num,afterNum) = span isDigit atNum
    negatives = takeWhile (== '-') (reverse beforeNum)
    sign = (-1) ^ length negatives

class IogiiType a where
  truthyChar :: a -> Bool
  truthyInt :: a -> Bool
  zeroChar :: a -> a
  zeroInt :: a -> a

instance IogiiType Integer where
  truthyChar = not . (flip Set.member falseChars)
  truthyInt = (/= 0)
  zeroChar a = 32
  zeroInt a = 0

instance IogiiType a => IogiiType [a] where
  truthyChar = (not . null)
  truthyInt = truthyChar
  zeroChar a = []
  zeroInt = zeroChar

truthyEmpty :: [a] -> Bool
truthyEmpty = (not . null)
zeroEmpty :: [a] -> [a]
zeroEmpty a = []

iogUnwords :: [[Integer]] -> [Integer]
iogUnwords = intercalate [32]
iogUnlines :: [[Integer]] -> [Integer]
iogUnlines = concatMap (++[10])

-- int ops
iogAdd = (+)
iogSub = (-)
iogMult = (*)
iogDiv a b = if b == 0 then 0 else a `div` b
iogMod a b = if b == 0 then 0 else a `mod` b
iogPow a b
  | b < 0 && a == 0 = 0
  | b < 0 = 1 `div` pow
  | otherwise = pow
  where pow = a^(abs b)
iogNegate x = -x
iogAbs = abs
iogCountTo x = [1..x]
iogWholes = [0..]
iogSum = sum :: [Integer] -> Integer
iogSucc = (+1)
iogPred x = x-1

-- char ops
iogCharRange a b = [a..b]
iogRead = iogHeadZeroA zeroInt . iogReadAll
iogReadAll x = readAll (map myChr x)
iogOrd = id
iogChr = id
iogStr = (map myOrd) . show :: Integer -> [Integer]
iogStrip = f . f where f = reverse . dropWhile (not . truthyChar) :: [Integer] -> [Integer]
iogReplicate a b = concat $ genericReplicate b a
iogJoin a b = if null a then [] else head a ++ concat (zipWith (++) b (tail a))
iogSplit a b = filter (not . null) $ iogSplitKeepEmpties a (repeat b)
iogSplitKeepEmpties a b
  | null a || null b = [a]
  | otherwise = maybe
    ((head a : head rhs) : tail rhs)
    (\remainder -> [] : iogSplitKeepEmpties remainder (tail b))
    (stripPrefix (head b) a)
  where
    rhs = iogSplitKeepEmpties (tail a) b
charClasses = map (Set.fromList) [
    ['a'..'z'],
    ['A'..'Z'],
    ['0'..'9'],
    [' '..chr 126] \\\\ (['a'..'z']++['A'..'Z']++['0'..'9']++" \n"),
    " \n"
  ]
iogCharClass a b = bool2i $ any (Set.member (myChr a)) $ (iogFilterTruthyB (/=0) charClasses (iogToBase b 2))

-- generic ops
iogTake = flip genericTake
iogDrop = flip genericDrop
iogJust = (:[])
iogCons = flip (:)
iogNil = []
iogAppend = (++)
iogReverse = reverse
iogNotTruthyA truthyFn x = 1 - bool2i (truthyFn x)
iogRepeat = repeat
iogTakeWhileTruthyB truthyFn a b = iogTakeWhileHelper a (map truthyFn b) where
  iogTakeWhileHelper [] _ = []
  iogTakeWhileHelper _ [] = []
  iogTakeWhileHelper (a:as) (b:bs)
      | b = a : iogTakeWhileHelper as bs
      | otherwise = []
iogTakeWhile2TruthyB = iogTakeWhileTruthyB
iogGetZeroA zeroFn a b = if null rest then zeroFn (head a) else head rest
  where rest = genericDrop b a
iogHeadZeroA zeroFn a = if null a then zeroFn (head a) else head a
iogTail a = if null a then [] else tail a
iogLastZeroA zeroFn a = if null a then zeroFn (head a) else last a
iogOrTruthyA truthyFn a b = if truthyFn a then a else b
iogOr2 a b = if a /= 0 then iogStr(a) else b

iogTransposeZeroA zeroFn a = takeWhile (not . null)
  $ map (map $ iogHeadZeroA zeroFn)
  $ map rstrip
  $ iterate (map iogTail) a
  where
    rstrip [] = []
    rstrip (h:t)
      | null h && null rest = []
      | otherwise = h : rest
      where rest = rstrip t

iogLen = genericLength
iogSortBy a b = map fst $ sortOn snd (zip a b)
iogSortBy2 :: Ord b => [a] -> [b] -> [a] -- why is this needed? todo
iogSortBy2 = iogSortBy
iogConcat :: [[a]] -> [a]
iogConcat = concat
iogFilterTruthyB truthyFn = (catMaybes .) . zipWith (\ai bi->if truthyFn bi then Just ai else Nothing )
iogSetDiff :: Eq a => [a] -> [a] -> [a]
iogSetDiff a b = a \\\\ b
iogIfElseTruthyA truthyFn a b c = if truthyFn a then b else c
iogIfElse2TruthyA = iogIfElseTruthyA
iogZeroPadZeroA zeroFn a = iogPad a (zeroFn $ head a)
iogEqual a b = bool2i (a == b)
iogLessThan a b = bool2i (a < b)
iogIndex a b = toInteger $ maybe 0 (+1) (elemIndex b a)

iogReshape a b
  | null b = []
  | n>0 && null a = []
  | n <= 0 = [] : (iogReshape a $ tail b)
  | otherwise = genericTake n a : if null d then [] else iogReshape (tail d) (tail b)
  where
    n = head b
    d = genericDrop (n-1) a

iogIsFirst :: Ord a => [a] -> [Integer]
iogIsFirst a = zipWith ((bool2i .) . (not .) . Set.member) a sets where
  sets = Set.empty : zipWith Set.insert a sets

iogChunkWhenTruthyB truhtyFn a b = chunkWhenHelper a (map truhtyFn b)
chunkWhenHelper a b
  | null a = [[]]
  | otherwise = (head a : if truthy then head rest else []) : (if truthy then tail rest else rest)
  where
    rest = if null b then [[]] else chunkWhenHelper (tail a) (tail b)
    truthy = null b || head b
iogChunkWhen2TruthyB = iogChunkWhenTruthyB

-- low rank overrides
iogUppercase a = if a >= myOrd('a') && a <= myOrd('z') then a-32 else a
iogLowercase a = if a >= myOrd('A') && a <= myOrd('Z') then a+32 else a
iogSplitWS a = filter (not . null) $ map iogStrip $ chunkWhenHelper a (map truthyChar a)
iogDigits a = if a == 0 then [0] else iogToBase a 10
iogUndigits a = iogBaseFrom 10 $ concat (map iogDigits a)
iogKCopy = flip genericReplicate

iogToBase a b = if b==0 then error "base 0" else reverse $ toBaseHelper (abs a) where
  sign = if a > 0 then 1 else -1
  toBaseHelper a
    | a == 0 = []
    | otherwise = digit : toBaseHelper ((a-digit*sign)`div`b)
    where
      digit = (a `mod` b)*sign

iogBaseFrom b a = last results where
  results = 0 : zipWith (\x aa->x*b + aa) results a

iogRangeBegin a = [a..]
iogRangeTo a = [0..a-1]

iogSqrt x
  | x < 0 = error "negative square root"
  | x == 0 = 0
  | otherwise = sqrtGuess x x
sqrtGuess guess x = case ((x `div` guess) + guess) `div` 2 of
   r | r>=guess -> guess
     | otherwise -> sqrtGuess r x

iogMin a b = minimum [a,b]
iogMax a b = maximum [a,b]
iogPow10 = (10^)
iogProd = product :: [Integer] -> Integer

-- internal ops
iogPad :: [a] -> a -> [a]
iogPad a b = (if null a then b else head a) : iogPad (iogTail a) b
iogZeroZeroA zeroFn a = zeroFn $ head a
iogZeromZeroA = iogZeroZeroA

-- intuitive overloads
iogJoin2 a = iogJoin (map iogJust a)

-- special ops
iogDel = undefined
iogVersion = map myOrd $ VERSION ++ ", " ++ compilerName ++ ": " ++ show compilerVersion
iogType ts a = map myOrd $ ts
iogShow coerceFn a = map myOrd $ show $ coerceFn a

main=do
  hSetEncoding stdin char8
  hSetEncoding stdout char8
  rawArgs <- getArgs
  interact (iogMain rawArgs)

-- END HEADER --

)

Header.sub!("VERSION", to_eager_str(Ops["version"].ways[0].impl.call).inspect)

def to_hs_type(type, rank)
  type_and_rank_to_str(type == EmptyType ? "a" : "Integer", rank)
end

ZipNames = ["", "map", "zipWith", "zipWith3"]
def to_hs_zips(n, nargs, op)
  n <= 0 ? op : "#{ZipNames[nargs]} (#{to_hs_zips(n-1, nargs, op)})"
end

def generate_hs(source, pp_sep)
  output Header

  _,_,_,raw_mode = *lex_parse(source)

  if raw_mode
    output "iogMain rawArgs input = iogMain0 where
   inputLines = if null rawArgs then lines input else rawArgs
   iogStdinLines = map (map myOrd) inputLines\n"
    possible_input_formats = ["a\nb"]
  else
    output 'iogMain rawArgs input
  | null inputLines = iogMain5
  | onlyNums = case nums of
   [[_]] -> iogMain0
   [_] -> iogMain1
   _ -> if all ((==1) . length) nums then iogMain1 else iogMain2
  | otherwise = if length inputLines <= 1 then iogMain3 else iogMain4
  where
   inputLines = if null rawArgs then lines input else rawArgs
   nums = map readAll inputLines
   nonNums = zipWith iogSplitKeepEmpties inputLines (map (map show) nums)
   onlyNums = not (null (concat nums)) && all numLine nonNums
   numLine cut = head cut == "" && all isSep (tail (if null (last cut) && length cut > 1 then init cut else cut))
   isSep s = s == "," || s == ", " || s == " "
   iogAutoInputInt = head $ head nums
   iogAutoInputListInt = concat nums
   iogAutoInputListListInt = nums
   iogAutoInputListChar = map myOrd (if null inputLines then "" else head inputLines)
   iogAutoInputListListChar = map (map myOrd) inputLines
'
   possible_input_formats = ["1","1 1","1 1\n1","a","a\nb",""]
  end

  possible_input_formats.each.with_index{|fake_input, i|
    $ReadStdinLines = lines(str_to_lazy_list(fake_input).const).const
    begin
      ast, ast_out_inds, registers, ir2, ir2_inds, ir3, ir3_ind = run(source, nil, pp_sep)
      output "   iogMain%d =\n    let\n" % i
      to_hs_main(ir3,ir3_ind)
    rescue IogiiError => e
      output(("   iogMain%d = error %p\n" % [i, e.message]).gsub("\\e","\\x1b"))
    end
  }
end

def to_hs_main(ir3, ir3_ind)
  ir3.each.with_index{|node,i|
    args = node.args.map{|a|"a#{a} "}.join
    if node.way.name == "data"
      op = to_strict(node.way.impl.call.const).inspect
    else
      op = "iog#{node.way.name[0].capitalize+node.way.name[1..]}"
      if Header.include?(op+"TruthyB")
        op = "#{op}TruthyB truthy#{type_to_str(ir3[ir3[i].args[1]].type).capitalize}"
      elsif Header.include?(op+"TruthyA")
        op = "#{op}TruthyA truthy#{type_to_str(ir3[ir3[i].args[0]].type).capitalize}"
      elsif Header.include?(op+"ZeroA")
        op = "#{op}ZeroA zero#{type_to_str(ir3[ir3[i].args[0]].type).capitalize}"
      elsif op == "iogType"
        arg = ir3[ir3[i].args[0]]
        op += " " + type_and_rank_to_str(arg.type, arg.rank).inspect
      elsif op == "iogShow"
        arg = ir3[ir3[i].args[0]]
        if arg.type == CharType
          op += " (" + to_hs_zips(arg.rank, 1, "myChr") + ")"
        elsif arg.type == EmptyType
          op += " (" + to_hs_zips(arg.rank, 1, "toInteger") + ")"
        else
          op += " id"
        end
      end
    end

    output "      a#{i} = #{to_hs_zips(node.zip_level, node.args.size, op)} #{args}:: #{to_hs_type(node.type, node.rank)}\n"
  }
  output "    in map myChr a#{ir3_ind}\n"
end
