# Vectorization

Capitalizing an op and/or proceeding with a `,` do not fully unvectorize the operation, they only decrease it by 1, but they can be combined and you may use multiple `,`s.

For example if we wish to test rank 2 lists for equality there are 3 possible ways to do it:

Fully vectorized:

    "abc","xyz" "abc","ijk" q -> [[1,1,1],[0,0,0]]

Partially vectorized:

    "abc","xyz" "abc","ijk" Q -> [1,0]

Unvectorized:

    "abc","xyz" "abc","ijk" Q, -> 0

## Broadcasting With Excess Rank

Vectorization occurs when arg(s) to ops have excess rank (higher rank than the type signature of the op). If that excess rank is uneven then the smaller excess one needs to be broadcasted (aka repeated) to match the higher excess. When the smaller excess is 0. Then there is only one way to repeat it. But if that smaller excess is >0, then there are multiple ways it could be repeated, iogii repeats at lowest rank possible for the op (maximally vectorized).

In this example the first arg excess rank is 2, and the second arg 1. So the second arg needs to be broadcasted.

    1,2,,4,5 10,100+ -> [[11,12],[104,105]]

Since the op takes scalars the highest vectorization level it could be broadcasted at is scalars, so the broadcast is equivalent to just doing a fully vectorized `repeat`:

    1,2,,4,5 10,100 r + -> [[11,12],[104,105]]

## Cartesian Product

You can utilize broadcasting to easily do cartesian products by doing the non default repeat on the desired arg of a binary op (depending on which transpose you want):

    1,2 10,100R+ -> [[11,101],[12,102]]

    1,2R 10,100+ -> [[11,12],[101,102]]
