# extend default rules are for: https://stackoverflow.com/questions/79516057/solving-ambiguous-type-variable-errors-without-adding-a-specific-type-annotation/79516109?noredirect=1#comment140231167_79516109
Header = %q({-# LANGUAGE ExtendedDefaultRules #-}

import System.IO
import Data.List
import Data.Char
import Data.String
import Data.Maybe
import System.Info
import qualified Data.Set as Set
import qualified Data.Map as Map
import System.Environment

myChr :: Integer -> Char
myChr i = chr $ fromIntegral i `mod` 256
myOrd :: Char -> Integer
myOrd c = fromIntegral $ ord c
bool2i :: Bool -> Integer
bool2i b = if b then 1 else 0
falseChars = Set.fromList [0,9,10,11,12,13,32]
truthyChar :: Integer -> Bool
truthyChar = not . (flip Set.member falseChars)
readAll :: String -> [Integer]
readAll xs =
  if num == [] then []
  else sign * (read num :: Integer) : readAll afterNum
  where
    (beforeNum,atNum) = span (not . isDigit) xs
    (num,afterNum) = span isDigit atNum
    negatives = takeWhile (== '-') (reverse beforeNum)
    sign = (-1) ^ length negatives

iogUnwords :: [[Integer]] -> [Integer]
iogUnwords = intercalate [32]
iogUnlines :: [[Integer]] -> [Integer]
iogUnlines = concatMap (++[10])
iogLines [] = [] -- copied from GHC but with integers instead of chars
iogLines s  = cons (case break (== 10) s of
              (l, s') -> (l, case s' of
                    []      -> []
                    _:s''   -> iogLines s''))
    where cons ~(h, t) =  h : t

iogError msg = error $ "\x1b[31mERROR: \x1b[0m" ++ msg

-- int ops
iogAdd = (+)
iogSub = (-)
iogCharSubtraction = (-)
iogMult = (*)
iogDiv a b = if b == 0 then 0 else a `div` b
iogMod a b = if b == 0 then 0 else a `mod` b
iogPow a b
  | b < 0 && a == 0 = 0
  | b < 0 = 1 `div` pow
  | otherwise = pow
  where pow = a^(abs b)
iogNegate x = -x
iogAbs = abs
iogCountTo x = [1..x]
iogWholes = [0..]
iogSum = sum :: [Integer] -> Integer
iogSucc = (+1)
iogPred x = x-1

-- char ops
iogCharRange a b = [a..b]
iogRead = iogHeadZero 0 . iogReadAll
iogReadAll x = readAll (map myChr x)
iogOrd = id
iogChr = id
iogStr = (map myOrd) . show :: Integer -> [Integer]
iogEstr :: a -> [Integer]
iogEstr a = a `seq` undefined
iogStrip = f . f where f = reverse . dropWhile (not . truthyChar) :: [Integer] -> [Integer]
iogReplicate a b = concat $ genericReplicate b a
iogJoin a b = if null a then [] else head a ++ concat (zipWith (++) b (tail a))
iogSplit a b = filter (not . null) $ iogSplitKeepEmpties a (repeat b)
iogSplitKeepEmpties a b
  | null a || null b = [a]
  | otherwise = maybe
    ((head a : head rhs) : tail rhs)
    (\remainder -> [] : iogSplitKeepEmpties remainder (tail b))
    (stripPrefix (head b) a)
  where
    rhs = iogSplitKeepEmpties (tail a) b
substrInd needle haystack = maybe (length haystack) id (findIndex (isPrefixOf needle) (tails haystack))
iogDropUntilAfterSubstring a b = drop (substrInd b a + length b) a
iogKeepUntilSubstring a b = take (substrInd b a) a
iogGetSubstring a b = take (length b) $ drop (substrInd b a) a
iogCharClass a = concat $ charClass a (replicate (length charClasses) False) where
  charClass [] _ = []
  charClass (a:as) used =
    let
      is = [i | i <- [0..length charClasses - 1], Set.member a (charClasses !! i)]
      i = head is
    in if null is || used !! i
       then charClass as used
       else (charClassesLists !! i) : charClass as (markUsed used i)
  markUsed used i = take i used ++ [True] ++ drop (i + 1) used
  charClassesLists = map (map myOrd) [
      ['a'..'z'],
      ['A'..'Z'],
      ['0'..'9'],
      [' '..chr 126] \\\\ (['a'..'z']++['A'..'Z']++['0'..'9']++" \n"),
      " \n"
    ]
  charClasses = map (Set.fromList) charClassesLists
iogRightJustify a b = replicate (fromInteger b - length a) 32 ++ a

-- generic ops
iogTake = flip genericTake
iogDrop = flip genericDrop
iogJust = (:[])
iogCons = flip (:)
iogNil = []
iogAppend = (++)
iogReverse = reverse
iogNotTruthyA0 truthyFn x = 1 - bool2i (truthyFn x)
iogRepeat = repeat
iogTakeWhileTruthyB1 truthyFn a b = iogTakeWhileHelper a (map truthyFn b) where
  iogTakeWhileHelper [] _ = []
  iogTakeWhileHelper _ [] = []
  iogTakeWhileHelper (a:as) (b:bs)
      | b = a : iogTakeWhileHelper as bs
      | otherwise = []
iogGetZero zero a b = if null rest then zero else head rest
  where rest = genericDrop b a
iogHeadZero zero a = if null a then zero else head a
iogTail a = if null a then [] else tail a
iogInit = init
iogLastZero zero a = if null a then zero else last a
iogConsDefaultZero zero a = zero : a

iogTransposeZero zero a = takeWhile (not . null)
  $ map (map $ iogHeadZero zero)
  $ map rstrip
  $ iterate (map iogTail) a
  where
    rstrip [] = []
    rstrip (h:t)
      | null h && null rest = []
      | otherwise = h : rest
      where rest = rstrip t

iogLen = genericLength
iogSortBy a b = map fst $ sortOn snd (zip a b)
iogConcat :: [[a]] -> [a]
iogConcat = concat
iogFilterTruthyB1 truthyFn = (catMaybes .) . zipWith (\ai bi->if truthyFn bi then Just ai else Nothing )

iogSetDiff :: Ord a => [a] -> [a] -> [a]
iogSetDiff xs ys = go xs $ foldr (\x -> Map.insertWith (+) x 1) Map.empty ys
  where
    go :: (Ord a) => [a] -> Map.Map a Int -> [a]
    go [] _ = []
    go (x:xs) m
      | Map.findWithDefault 0 x m > 0 = go xs (Map.adjust pred x m)
      | otherwise = x : go xs m

iogIfElseTruthyA0 truthyFn a b c = if truthyFn a then b else c
iogPadDefaultZero zero a = iogPad a zero
iogEqual a b = bool2i (a == b)
iogLessThan a b = bool2i (a < b)
iogIndices a b = map toInteger (elemIndices b a)

iogReshape a b
  | null b = []
  | n>0 && null a = []
  | n <= 0 = [] : (iogReshape a $ tail b)
  | otherwise = genericTake n a : if null d then [] else iogReshape (tail d) (tail b)
  where
    n = head b
    d = genericDrop (n-1) a

iogIsFirst :: Ord a => [a] -> [Integer]
iogIsFirst a = zipWith ((bool2i .) . (not .) . Set.member) a sets where
  sets = Set.empty : zipWith Set.insert a sets

iogChunkWhenTruthyB1 truhtyFn a b = chunkWhenHelper a (map truhtyFn b)
chunkWhenHelper a b
  | null a = [[]]
  | otherwise = (head a : if truthy then head rest else []) : (if truthy then tail rest else rest)
  where
    rest = chunkWhenHelper (tail a) (iogTail b)
    truthy = null b || head b

-- low rank overrides
iogUppercase a = if a >= myOrd('a') && a <= myOrd('z') then a-32 else a
iogLowercase a = if a >= myOrd('A') && a <= myOrd('Z') then a+32 else a
iogWords a = filter (not . null) $ map iogStrip $ chunkWhenHelper a (map truthyChar a)
iogDigits a = if a == 0 then [0] else iogToBase a 10
iogUndigits a = iogBaseFrom 10 (concat (map iogDigits a))

iogToBase a b = if b==0 then iogError "base 0" else reverse $ toBaseHelper (abs a) where
  sign = if a > 0 then 1 else -1
  toBaseHelper a
    | a == 0 = []
    | otherwise = digit : toBaseHelper ((a-digit*sign)`div`b)
    where
      digit = (a `mod` b)*sign

iogBaseFrom b a = last results where
  results = 0 : zipWith (\x aa->x*b + aa) results a

iogRangeBegin a = [a..]
iogRangeTo a = [0..a-1]

iogSqrt x
  | x < 0 = iogError "negative square root"
  | x == 0 = 0
  | otherwise = sqrtGuess x x
sqrtGuess guess x = case ((x `div` guess) + guess) `div` 2 of
   r | r>=guess -> guess
     | otherwise -> sqrtGuess r x

iogMin a b = minimum [a,b]
iogMax a b = maximum [a,b]
iogPow10 = (10^)
iogProd = product :: [Integer] -> Integer

-- internal ops
iogPad :: [a] -> a -> [a]
iogPad a b = (if null a then b else head a) : iogPad (iogTail a) b
iogZeroZero zero a = zero
iogZeromZero = iogZeroZero

-- intuitive overloads
iogJoinM a = iogJoin (map iogJust a)

-- special ops
iogDel = undefined
iogVersion = map myOrd $ VERSION ++ ", " ++ compilerName ++ ": " ++ show compilerVersion
iogType ts a = map myOrd $ ts
iogShow coerceFn a = map myOrd $ show $ coerceFn a

main=do
  hSetEncoding stdin char8
  hSetEncoding stdout char8
  rawArgs <- getArgs
  interact (iogMain rawArgs)

-- END HEADER --

)

Header.sub!("VERSION", to_eager_str(Ops["version"].ways[0].impl.call).inspect)
if Encoding.default_external != ByteEncoding
  Header.gsub!("`mod` 256","")
  Header.gsub!('hSetEncoding stdin char8','')
  Header.gsub!('hSetEncoding stdout char8','')
end

def to_hs_type(type, rank)
  (type == EmptyType ? "Ord a => " : "") +
    type_and_rank_to_str(type == EmptyType ? "a" : "Integer", rank)
end

ZipNames = ["", "map", "zipWith", "zipWith3"]
def to_hs_zips(n, nargs, op)
  n <= 0 ? op : "#{ZipNames[nargs]} (#{to_hs_zips(n-1, nargs, op)})"
end

def does_source_use_input(source)
  $ReadStdin = str_to_lazy_list("5").const
  $ReadStdinLines = read_stdin_lines.const
  $input_checked = false
  begin
    gen_graph(source, ast_cb: ->_,_{ return $input_checked })
  rescue IogiiError => e
  end
  $input_checked
end

def generate_hs(source, pp_sep)
  output Header

  if is_raw_mode(lex(source))
    output "iogMain rawArgs input = if null rawArgs then iogMain0 else iogMain1 where
   iogRawArgs = map (map myOrd) rawArgs
   iogRawStdin = map myOrd input\n"
   possible_input_formats = [0,1]
  else
    if !does_source_use_input(source) # do this to avoid unnecessarily awaiting input that is never used
      output "iogMain rawArgs input = iogMain0 where\n"
      possible_input_formats = [""]
    else
      output 'iogMain rawArgs input
  | null inputLines = iogMain5
  | onlyNums = case nums of
   [[_]] -> iogMain0
   [_] -> iogMain1
   _ -> if all ((==1) . length) nums then iogMain1 else iogMain2
  | otherwise = if length inputLines <= 1 then iogMain3 else iogMain4
  where
   inputLines = if null rawArgs then lines input else rawArgs
   nums = map readAll inputLines
   nonNums = zipWith iogSplitKeepEmpties inputLines (map (map show) nums)
   onlyNums = not (null (concat nums)) && all numLine nonNums
   numLine cut = head cut == "" && all isSep (tail (if null (last cut) && length cut > 1 then init cut else cut))
   isSep s = s == "," || s == ", " || s == " "
   iogAutoInputInt = head $ head nums
   iogAutoInputListInt = concat nums
   iogAutoInputListListInt = nums
   iogAutoInputListChar = map myOrd (head inputLines)
   iogAutoInputListListChar = map (map myOrd) inputLines
   iogAutoInputListEmpty = []' + "\n"
      possible_input_formats = ["1","1 1","1 1\n1","a","a\nb",""]
    end
  end

  possible_input_formats.each.with_index{|fake_input, i|
    if Integer === fake_input
      $ReadStdin = str_to_lazy_list("asdf").const
      $ReadStdinLines = read_stdin_lines.const
      $raw_args = fake_input == 1 ? true : nil
    else
      $raw_args = nil
      $ReadStdin = str_to_lazy_list(fake_input).const
      $ReadStdinLines = read_stdin_lines.const
    end

    begin
      ir3, ir3_ind = gen_graph(source, pp_sep: pp_sep)
      output "   iogMain%d =\n    let\n" % i
      to_hs_main(ir3,ir3_ind)
    rescue IogiiError => e
      output(("   iogMain%d = error %p\n" % [i, e.message]).gsub("\\e","\\x1b"))
    end
  }
end

def to_hs_main(ir3, ir3_ind)
  ir3.each.with_index{|node,i|
    args = node.args.map{|a|"a#{a} "}.join
    if node.way.name == "data"
      op = to_strict(node.way.impl.call.const).inspect
    else
      op = "iog#{node.way.name[0].capitalize+node.way.name[1..]}"
      # haskell op names proceed names with special forms to denote what additional information they need for polymorphism
      if Header =~ /#{op}Truthy(.)(\d)/
        arg = ir3[node.args[$1.ord - ?A.ord]]
        # here we calculate rank rather than use way.mod because ab type adjustments could change it
        truthyFn = if arg.rank - node.zip_level > $2.to_i || arg.type == EmptyType
            "(not . null)"
          elsif arg.type == IntType
            "(/= 0)"
          elsif arg.type == CharType
            "truthyChar"
          else
            # force the value (which is invalid) to be calculated and return a value of type bool
            "(flip seq (undefined::Bool))"
          end
        op = "#$& #{truthyFn}"
      elsif Header =~ /#{op}Zero/ # the zero arg is always the first one
        a = ir3[node.args[0]]
        zero = if node.way.mod > 0
            "[]"
          elsif a.type == CharType
            "32"
          else # int / empty
            "0"
          end
        op = "#$& #{zero}"
      elsif op == "iogType"
        arg = ir3[ir3[i].args[0]]
        op += " " + type_and_rank_to_str(arg.type, arg.rank).inspect
      elsif op == "iogShow"
        arg = ir3[ir3[i].args[0]]
        if arg.type == CharType
          op += " (" + to_hs_zips(arg.rank, 1, "myChr") + ")"
        elsif arg.type == EmptyType
            # force the value (which is invalid) to be calculated and return a value of type int (any type that can be shown would work)
          op += " (" + to_hs_zips(arg.rank, 1, "(flip seq (undefined::Int))") + ")"
        else
          op += " id"
        end
      end
    end

    output "      a#{i} :: #{to_hs_type(node.type, node.rank)}\n"
    output "      a#{i} = #{to_hs_zips(node.zip_level, node.args.size, op)} #{args}\n"
  }
  output "    in map myChr a#{ir3_ind}\n"
end
