require 'cgi'

class String
  def td
    "<td>"+self.escape+"</td>"
  end
  def tdcode(name=false)
    "<td><code>"+self.gsub(/(-|=)>/,"→").escape+"</code></td>"
  end
  def escape
    CGI.escape_html self
  end
end

puts '<table class="quickref">'

def category(name)
  $done = true if name["internal"]
  return if $done
  puts '<tr><td colspan="3" class="center"><b>'+name+'</b></td></tr>'
end

def quickref_op(names, desc, example)
  puts '<tr>'+names.tdcode(true)+desc.td+example.tdcode+"</tr>"
end

def mk_op(names, type_sig, example="", block: false, vectorize: true, promote: true, uses_zero: false, &impl)
  return if $done

  puts "<tr>"
  if names == $last_names
    puts "".td
  else
    puts names.tdcode(true)
    $last_names = names
  end

  type_sig = if names.split.include? "foldr0"
    "([a] -> [a]) -> a"
  elsif names.split.include? "iterate0"
    "([a] -> [a]) -> [a]"
  elsif names.split.include? "foldr"
    "a ([a] -> [a]) -> a"
  elsif names.split.include? "iterate"
    "[a] ([a] -> [a]) -> [a]"
  elsif names.split.include? "mdup"
    "a (a -> b) -> b a"
  elsif names.split.include? "dup"
    "a -> a a"
  elsif names.split.include? "peek"
    "a b -> a b a"
  elsif names.split.include? "mpeek"
    "a b (a -> c) -> c b a"
  elsif names.split.include? "let"
    "a let name -> (sets name)"
  elsif names.split.include? "set"
    "a set name -> (sets name) a"
  else
    type_sig
  end
  if ["pp","nuke"].include? names
    type_sig = type_sig[/^.*->/]
  end

  puts type_sig.tdcode
  puts example.sub(' (unstable)','').tdcode
  puts "</tr>"
end

require "./ops.rb"

puts "</table>"
