require 'cgi'

class String
  def td
    "<td>"+self.escape+"</td>"
  end
  def tdcode(name=false)
    "<td><code>"+self.gsub(/(-|=)>/,"→").escape+"</code></td>"
  end
  def escape
    CGI.escape_html self
  end
end

puts '<table class="quickref">'

def category(name)
  $done = true if name["internal"]
  return if $done
  puts '<tr><td colspan="3" class="center"><b>'+name+'</b></td></tr>'
end

def quickref_op(names, desc, example)
  puts '<tr>'+add_link_to_name(names.tdcode(true))+"<td>#{desc}</td>"+example.tdcode+"</tr>"
end

OpsWithLinks = {
  "read" => "ops.html#readreadall",
  "readAll" => "ops.html#readreadall",
  "fromBase" => "ops.html#tobasefrombase",
  "toBase" => "ops.html#tobasefrombase",
  "undigits" => "ops.html#digitsundigits",
  "digits" => "ops.html#digitsundigits",
  "Default" => "types.html#defaultvalue",
  "reshape" => true,
  "transpose" => true,
  "get" => true,
  "setDiff" => true,
  "sortBy" => true,
  "join" => true,
  "chunkWhen" => true,
  "charClass" => true,
  "isCharClass" => "ops.html#charclass",
  "iterate" => true,
  "foldr" => true,
  "foldr0" => "ops.html#meldfoldr0",
  "iterate0" => "ops.html#expanditerate0",
  "$" => "syntax.html#codeclassinlinecode",
  "=" => "syntax.html#setnextvar",
  "input" => "IO.html",
  "implicit" => "syntax.html#implicitvalues",
  "set" => "syntax.html#codeclassinlinesetcode",
  "let" => "syntax.html#codeclassinlinesetcode",
  "pad" => "circularprogramming.html#howfoldrworks",
}

def add_link_to_name(names)
  OpsWithLinks.each{|name,dest|
    names.sub!(/#{Regexp.escape name}(?=\<\/code)/){
      dest = "ops.html#"+name.downcase if dest == true
      '<a href="' + dest + '">' + name + '</a>'
    }
  }
  names
end

def mk_op(names, type_sig, example="", block: false, vectorize: true, promote: true, uses_zero: false, &impl)
  return if $done

  puts "<tr>"
  if names == $last_names
    puts "".td
  else
    puts $last_names = add_link_to_name(names.tdcode(true))
  end

  type_sig = if names.split.include? "foldr0"
    "([a] -> [a]) -> a"
  elsif names.split.include? "iterate0"
    "([a] -> [a]) -> [a]"
  elsif names.split.include? "foldr"
    "a ([a] -> [a]) -> a"
  elsif names.split.include? "iterate"
    "[a] ([a] -> [a]) -> [a]"
  elsif names.split.include? "mdup"
    "a (a -> b) -> b a"
  elsif names.split.include? "dup"
    "a -> a a"
  elsif names.split.include? "peek"
    "a b -> a b a"
  elsif names.split.include? "mpeek"
    "a b (a -> c) -> c b a"
  elsif names.split.include? "let"
    "a let name -> (sets name)"
  elsif names.split.include? "set"
    "a set name -> (sets name) a"
  else
    type_sig.gsub('b','btype')
  end

  puts type_sig.tdcode.gsub('btype','<a href="types.html#opswithtwogenerictypes">b</a>')
  puts example[0,35].tdcode
  puts "</tr>"
end

require "./ops.rb"

puts "</table>"
