# IO

## Placement

Input is implicitly the first value placed on the stack in your program. But if you don't use it, it isn't printed, essentially it is optionally used.

    pay attention to me!
    ---
    5
    ---
    5

This is a multiline example, the format is input, horizontal line, program, horizontal line, actual output. Inline examples do not show output but the pretty printed form of values (that you can generate with `show`)

    abc
    ---
    reverse
    ---
    cba


You can also explicitly use it with the `input` op, or `$` if you aren't inside another function.

If you want to have other values placed before the implicit input, put them at the end of your program and they will be rotated in to place beforehand (see [syntax](syntax.html) for more information on that).

    5
    ---
    - 6 # this will be unrotated back before the implicit input
    ---
    1

Rotation can even happen between `dup`-like ops multiple returns:

    hi
    ---
    a'.:
    ---
    .hi.

## Auto parsing

Input is automatically parsed. Any non numbers or commas will cause it to be treated as a string. Multiple lines will increase rank.

    5
    ---
    type
    ---
    int

<br>

    5 6
    ---
    type
    ---
    [int]

<br>

    5, 6
    ---
    type
    ---
    [int]

<br>

    5, 6
    7 8
    ---
    type
    ---
    [[int]]

<br>

    5a
    ---
    type
    ---
    [char]

<br>

    5
    6
    a
    ---
    type
    ---
    [[char]]

<br>

    type # empty input is nil (typeless)
    ---
    []


## Raw Modes

If you don't want auto parsing or want to do interactive IO, then you will need to use a raw mode.

Making the first character of the entire program a space puts iogii in raw line mode, input is treated as a list of lines (strings) with newlines removed.

Making the first character a `,` puts iogii in raw mode, the entire input is just a string with possible newline characters still intact.

## Output

Values that remain in the stack at the end of the main program are implicitly printed.

For each value:

1.   Ints are converting to strings.
2.   If the resulting rank is >= 2 then the inner strings are joined by " "
3.   While the remaining rank > 1, append to each list "\n" and then concat.

Examples:

    1
    ---
    1

(by rule 1)

    1 2
    ---
    12

(rule 1 twice)

    1,2
    ---
    1
    2

(rules 1 and 2)

    1,2,,3,4
    ---
    1 2
    3 4

(rules 1, 2 and 3)

    1,2,,3,4,,,5
    ---
    1 2
    3 4

    5

(rules 1, 2, and 3 applied twice)

These rules generally allow you to print without having to join by newlines or spaces explicitly, you can always increase the rank using `just`.

## Interactive Programs

Since iogii is lazy, you can do interactive input. However you must use raw mode, otherwise all input is read first in order to auto parse it.

For example:

    Darren
    ---
    , # raw mode
    "What's your name?\n"
        input
        "Hi, " input "\n" split Head append
        "no one there?"
    IfElse "\n"
    ---
    What's your name?
    Hi, Darren

Note that the if/else prevents it from printing "Hi," before they type anything. If we always printed "Hi, ..." it does not need to read any input before it knows that the output begins with "Hi,". If you did want to always say "Hi, ..." you could do things like reverse the appended output twice to make it depend on the input.

## Args

You can also take in input from the command line instead of STDIN, to do so pass in `--` followed by args. If compiling to Haskell, any args passed to the Haskell program will be treated as the input (don't need `--`).

They will be auto parsed unless raw mode is used as well.

## Encoding

iogii uses whatever encoding your system is set to. If the encoding is ASCII it will mod 256 your output characters.

You can set your encoding in the terminal with:

    export LANG=UTF-8       # utf8
    export LANG=iso-8859-1  # bytes

The online interpreter uses UTF-8.

If you wish to force the encoding of a specific string to bytes you can proceed it with a `b`. E.g.

    "☯️"  ord show "\n"
    "☯️"b ord show "\n"
    ---
    [9775,65039]
    [226,152,175,239,184,143]
