$warnings = {}

def warn(msg, from=nil)
  warning = to_location(from) + msg

  # don't do the same warning more than once (since code is parsed multiple times to handle auto input cases in engine/hs code gen
  return if $warnings[warning]
  $warnings[warning] = true

  error_output "WARNING: ".red + warning + "\n"
end

def to_location(from)
  token = case from
    when Token
      from
    when AST
      from.token
    when IR
      from.token
    when NilClass
      nil
    else
      raise "unknown location type %p " % from
    end

  if token
    "%s:%s (%s) " % [token.line_no||"?", token.char_no||"?", token.str]
  else
    ""
  end
end

class String
  def red
    "\e[31m#{self}\e[0m"
  end
end

class IogiiError < StandardError
  def initialize(message,from=nil)
    @message = message
    @from = from
  end
  def message
    "ERROR: ".red + to_location(@from) + @message
  end
end
