require_relative "./run.rb"
require_relative "./graphviz.rb"
require "js"
require "stringio"

class Promise
  alias orig_value value
  def value
    if Time.now - $start_time > 2.0
      error_output "timeout" # todo, do this from JS?
      exit
    end
    orig_value
  end
end

runbutton = JS.global[:document].getElementById("runbutton")
Program = JS.global[:document].getElementById("program")
Prettyprintbox = JS.global[:document].getElementById("prettyprintbox")
WEB_OUTPUT = JS.global[:document].getElementById("output")
WEB_STDERR = JS.global[:document].getElementById("stderr")
WEB_INPUT = JS.global[:document].getElementById("input")

def append_js(output_str, var, str)
  output_str << str
  var[:value] = output_str.to_js
end

def output(str)
  append_js($ruby_output, WEB_OUTPUT, str)
end

def error_output(str)
#   append_js($ruby_stderr, WEB_STDERR, str)
  output(str)
end

class String
  def red
    self
  end
end

WEB_OUTPUT[:value] = "ready"

def render_graphviz(graph, component)
  JS.eval('d3.select("#' + component + '").graphviz().renderDot('+graph.inspect+');')
end

run_cb = -> event {
  $ruby_output = ""
  $ruby_stderr = ""

  output(""); error_output("") # reset displays
  JS.eval('d3.selectAll("svg > *").remove();')

  input = StringIO.new(WEB_INPUT[:value].to_s)
  pretty_print = Prettyprintbox[:checked].to_s == "true"
  prog = Program[:value].to_s.bytes.map(&:chr).join

  $start_time = Time.now
  begin
    run_and_do_io(prog, input, pretty_print, false,
      ast_cb: -> ast, ast_out_inds {
        ast_graph = ast2viz(ast, ast_out_inds)
        render_graphviz(ast_graph, "ast_graph")
      },
      ir_cb: -> ir2, ir2_out_inds {
        ir_graph = ir2viz(ir2, ir2_out_inds)
        render_graphviz(ir_graph, "ir_graph")
      }
    )
  rescue IogiiError => e
    error_output e.message + "\n"
  rescue => e
    error_output "This is an internal iogii error, please report it!\n"
    raise e
  end
}

runbutton.call(:addEventListener, "click", &run_cb)
JS.global[:window].call(:addEventListener, 'popstate', &run_cb)

run_cb[nil]